jQuery(document).ready(function() {
	var Statistics = {},
		$ = jQuery,
		$sends_graph = $("#bbpp-thankmelater-sends-graph");
	
	Statistics.plotData = function () {
		var max_sends = 1,
			i,
			sends_data = bbpp_thankmelater_sends_data;
			
		for (i = 0; i < sends_data.data.length; i++) {
			max_sends = Math.max(max_sends, sends_data.data[i][1]);
		}
		
		$.plot(
			$sends_graph,
			[
				{
					color: "#FFFFFF",
					bars: {
						show: true,
						fillColor: "#21759B",
						lineWidth: 2,
						align: "center"
					},
					data: sends_data.data
				}
			],
			{
				xaxis: {
					tickLength: 0,
					ticks: sends_data.labels
				},
				yaxis: {
					tickLength: 0,
					minTickSize: 1,
					tickDecimals: 0,
					max: max_sends
				},
				grid: {
					borderWidth: 0,
					aboveData: true,
					markings: [
						{ 
							xaxis: {
								from: -0.5, 
								to: sends_data.length
							}, 
							yaxis: {
								from: 0,
								to: 0 
							}, 
							color: "#CCCCCC"
						},
						{
							xaxis: {
								from: -0.5,
								to: -0.5
							}, 
							yaxis: {
								from: 0,
								to: max_sends
							}, 
							color: "#E6E6E6" 
						}
					]
				}
			}
		);
	};
	
	if ($sends_graph.length) {
		Statistics.plotData();
	}
});